//
// C/C++ headers
//
#include <fstream>
#include <string.h>
#include <iostream>
#include <cstring>
#include <stdio.h>
//
// ROOT headers
//
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TArrayI.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
//
// YODA headers
//
#include <PamelaRun.h>
#include <PscuHeader.h>
#include <PscuEvent.h>
#include <EventHeader.h>
//
// RunInfo header
//
#include <RunInfo.h>
#include <GLTables.h>
//
// This program headers
//
#include <OrbitalInfo.h>
#include <OrbitalInfoCore.h>
#include <OrbitalInfoVerl2.h>

using namespace std;

//
// CORE ROUTINE
//
//
int OrbitalInfoCore(UInt_t run, TFile *file, TSQLServer *dbc, Int_t OrbitalInfoargc, char *OrbitalInfoargv[]){
  Int_t i = 0;
  //
  TString processFolder = "OrbitalInfoFolder";
  //
  // Set these to true to have a very verbose output.
  //
  Bool_t debug = false;
  //
  Bool_t verbose = false;

  if ( OrbitalInfoargc > 0 ){
    i = 0;
    while ( i < OrbitalInfoargc ){
      if ( !strcmp(OrbitalInfoargv[i],"-processFolder") ) {
	if ( OrbitalInfoargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)OrbitalInfoargv[i+1];
	i++;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--debug")) || (!strcmp(OrbitalInfoargv[i],"-g")) ) {
	verbose = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--verbose")) || (!strcmp(OrbitalInfoargv[i],"-v")) ) {
	verbose = true;
      };
      i++;
    };
  };
  //
  const char* outDir = gSystem->DirName(gSystem->DirName(file->GetPath()));
  //
  TTree *OrbitalInfotr = 0;
  UInt_t nevents = 0;
  //
  // variables needed to reprocess data
  //
  TString OrbitalInfoversion;
  ItoRunInfo *runinfo = 0;
  TArrayI *runlist = 0;
  TTree *OrbitalInfotrclone = 0;
  Bool_t reproc = false;
  Bool_t reprocall = false;
  UInt_t nobefrun = 0;
  UInt_t noaftrun = 0;
  UInt_t numbofrun = 0;
  stringstream ftmpname;
  TString fname;
  UInt_t totfileentries = 0;
  UInt_t idRun = 0; 
  //
  // variables needed to handle error signals
  //
  Int_t code = 0;
  Int_t sgnl;
  //
  // OrbitalInfo  classes
  //
  OrbitalInfo *orbitalinfo = new OrbitalInfo();
  OrbitalInfo *orbitalinfoclone = new OrbitalInfo();
  //
  // define variables for opening and reading level0 file
  //
  TFile *l0File = 0;
  TTree *l0tr = 0;
  // EM: open also header branch
  TBranch *l0head = 0;
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  // end EM
  //
  // Define other basic variables
  // 
  UInt_t procev = 0;
  stringstream file2;
  stringstream file3;
  stringstream qy;
  Int_t totevent = 0;
  UInt_t atime = 0;
  UInt_t re = 0;
  //
  // Working filename
  //
  TString outputfile;
  stringstream name;
  name.str("");
  name << outDir << "/";
  //
  // temporary file and folder
  //
  TFile *tempfile = 0;
  TTree *tempOrbitalInfo = 0;
  stringstream tempname;
  stringstream OrbitalInfofolder;
  tempname.str("");
  tempname << outDir;
  tempname << "/" << processFolder.Data();
  OrbitalInfofolder.str("");
  OrbitalInfofolder << tempname.str().c_str();
  gSystem->MakeDirectory(OrbitalInfofolder.str().c_str());
  tempname << "/OrbitalInfotree_run";
  tempname << run << ".root";  
  //
  // DB classes
  //
  GL_ROOT *glroot = new GL_ROOT();
  GL_TIMESYNC *dbtime = 0;
  //
  // Let's start!
  //
  // As a first thing we must check what we have to do: if run = 0 we must process all events in the file has been passed
  // if run != 0 we must process only that run but first we have to check if the tree MyDetector2 already exist in the file
  // if it exists we are reprocessing data and we must delete that entries, if not we must create it.
  // 
  if ( run == 0 )  reproc = true;
  //
  //
  // Output file is "outputfile"
  //
  if ( !file->IsOpen() ){
    //printf(" OrbitalInfo - ERROR: cannot open file for writing\n");
    throw -901;    
  };
  //
  // Retrieve GL_RUN variables from the level2 file
  //  
  OrbitalInfoversion = OrbitalInfoInfo(false); // we should decide how to handle versioning system
  //
  // create an interface to RunInfo called "runinfo"
  //
  runinfo = new ItoRunInfo(file);
  //
  // open "Run" tree in level2 file, if not existing return an error (sngl != 0)
  //
  sgnl = 0;
  sgnl = runinfo->Update(run, "ORB", OrbitalInfoversion);
  //sgnl = runinfo->Read(run);

  if ( sgnl ){
    //printf("OrbitalInfo - ERROR: RunInfo exited with non-zero status\n");
    code = sgnl;
    goto closeandexit;
  } else {
    sgnl = 0;
  };
  //
  // number of events in the file BEFORE the first event of our run
  //
  nobefrun = runinfo->GetFirstEntry();
  //
  // total number of events in the file 
  //
  totfileentries = runinfo->GetFileEntries();
  //
  // first file entry AFTER the last event of our run
  //
  noaftrun = runinfo->GetLastEntry() + 1;
  //
  // number of run to be processed
  //
  numbofrun = runinfo->GetNoRun();
  //
  // Try to access the OrbitalInfo tree in the file, if it exists we are reprocessing data if not we are processing a new run
  //
  OrbitalInfotrclone = (TTree*)file->Get("OrbitalInfo");
  //
  if ( !OrbitalInfotrclone ){
    //
    // tree does not exist, we are not reprocessing
    //
    reproc = false;
    if ( run == 0 ){
      if (verbose) printf(" OrbitalInfo - WARNING: you are reprocessing data but OrbitalInfo tree does not exist!\n");
    }
    if ( runinfo->IsReprocessing() && run != 0 ) {
      if (verbose) printf(" OrbitalInfo - WARNING: it seems you are not reprocessing data but OrbitalInfo\n versioning information already exists in RunInfo.\n");
    }
  } else {
    //
    // tree exists, we are reprocessing data. Are we reprocessing a single run or all the file?
    //
    reproc = true;
    //
    //
    if (verbose) printf("\n Preparing the pre-processing...\n");
    //
    if ( run == 0 ){
      //
      // we are reprocessing all the file
      // if we are reprocessing everything we don't need to copy any old event and we can just work with the new tree and delete the old one immediately
      //
      reprocall = true;
      //
      if (verbose) printf("\n OrbitalInfo - WARNING: Reprocessing all runs\n");
      //
    } else {
      //
      // we are reprocessing a single run, we must copy to the new tree the events in the file which preceed the first event of the run
      //
      reprocall = false;
      //
      if (verbose) printf("\n OrbitalInfo - WARNING: Reprocessing run number %u \n",run);
      //
      // copying old tree to a new file
      //
      tempfile = new TFile(tempname.str().c_str(),"RECREATE");
      tempOrbitalInfo = OrbitalInfotrclone->CloneTree(-1,"fast");
      tempOrbitalInfo->SetName("OrbitalInfo-old");
      tempfile->Write();
      tempfile->Close();  
    }
    //
    // Delete the old tree from old file and memory
    //
    OrbitalInfotrclone->Delete("all");
    //
    if (verbose) printf(" ...done!\n");
    //
  };
  //
  // create mydetector tree mydect
  // 
  file->cd();
  OrbitalInfotr = new TTree("OrbitalInfo-new","PAMELA OrbitalInfo data");
  OrbitalInfotr->Branch("OrbitalInfo","OrbitalInfo",&orbitalinfo);
  //
  if ( reproc && !reprocall ){
    //
    //  open new file and retrieve also tree informations
    //
    tempfile = new TFile(tempname.str().c_str(),"READ");
    OrbitalInfotrclone = (TTree*)tempfile->Get("OrbitalInfo-old");
    OrbitalInfotrclone->SetBranchAddress("OrbitalInfo",&orbitalinfoclone);
    //      
    if ( nobefrun > 0 ){
      if (verbose){
      printf("\n Pre-processing: copying events from the old tree before the processed run\n");   
      printf(" Copying %u events in the file which are before the beginning of the run %u \n",nobefrun,run);
      printf(" Start copying at event number 0, end copying at event number %u \n",nobefrun);
      }
      for (UInt_t j = 0; j < nobefrun; j++){
	//
	OrbitalInfotrclone->GetEntry(j);	  
	//
	// copy orbitalinfoclone to mydec
	//
	orbitalinfo->Clear();
	//
	memcpy(&orbitalinfo,&orbitalinfoclone,sizeof(orbitalinfoclone));
	//
	// Fill entry in the new tree
	//
	OrbitalInfotr->Fill();
	//
      };
      if (verbose) printf(" Finished successful copying!\n");
    };          
  };
  //
  // Get the list of run to be processed, if only one run has to be processed the list will contain one entry only.
  //
  runlist = runinfo->GetRunList();
  //
  // Loop over the run to be processed
  //
  for (UInt_t irun=0; irun < numbofrun; irun++){
    //
    // retrieve the first run ID to be processed using the RunInfo list
    //
    idRun = runlist->At(irun);
    if (verbose){
      printf("\n\n\n ####################################################################### \n");
      printf("                    PROCESSING RUN NUMBER %i \n",(int)idRun);
      printf(" ####################################################################### \n\n\n");
    }
    //
    runinfo->ID_ROOT_L0 = 0;
    //
    // store in the runinfo class the GL_RUN variables for our run
    //
    sgnl = 0;
    sgnl = runinfo->GetRunInfo(idRun);
    if ( sgnl ){
      if ( debug ) printf("\n OrbitalInfo - ERROR: RunInfo exited with non-zero status\n");
      code = sgnl;
      goto closeandexit;
    } else {
      sgnl = 0;
    };
    //
    // now you can access that variables using the RunInfo class this way runinfo->ID_REG_RUN
    //
    if ( runinfo->ID_ROOT_L0 == 0 ){
      if ( debug ) printf("\n OrbitalInfo - ERROR: no run with ID_RUN = %u \n\n Exiting... \n\n",idRun);
      code = -5;
      goto closeandexit;    
    };
    //
    // prepare the timesync for the db
    //
    dbtime = new GL_TIMESYNC(runinfo->ID_ROOT_L0,"ID",dbc);
    //
    // Search in the DB the path and name of the LEVEL0 file to be processed.
    //
    glroot->Query_GL_ROOT(runinfo->ID_ROOT_L0,dbc);
    //
    ftmpname.str("");
    ftmpname << glroot->PATH.Data() << "/";
    ftmpname << glroot->NAME.Data();
    fname = ftmpname.str().c_str();
    //
    // print out informations
    //
    totevent = runinfo->NEVENTS;
    if (verbose){
      printf("\n LEVEL0 data file: %s \n",fname.Data());
      printf(" RUN HEADER absolute time is:  %u \n",runinfo->RUNHEADER_TIME);
      printf(" RUN TRAILER absolute time is: %u \n",runinfo->RUNTRAILER_TIME);
      printf(" %i events to be processed for run %u: from %i to %i \n\n",totevent,idRun,runinfo->EV_FROM,runinfo->EV_FROM+totevent);
    }//
    // Open Level0 file
    l0File = new TFile(fname.Data());
    if ( !l0File ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: problems opening Level0 file\n");
      code = -6;
      goto closeandexit;
    };
    l0tr = (TTree*)l0File->Get("Physics");
    if ( !l0tr ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: no Physics tree in Level0 file\n");
      l0File->Close();
      code = -7;
      goto closeandexit;
    };
    // EM: open header branch as well
    l0head = l0tr->GetBranch("Header");
    if ( !l0head ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: no Header branch in Level0 tree\n");
      l0File->Close();
      code = -8;
      goto closeandexit;    
    };
    l0tr->SetBranchAddress("Header", &eh);
    // end EM
    nevents = l0head->GetEntries();
    //
    if ( nevents < 1 ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: Level0 file is empty\n\n");
      l0File->Close();
      code = -11;
      goto closeandexit;
    };
    //
    if ( runinfo->EV_TO > nevents-1 ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: too few entries in the registry tree\n");
      l0File->Close();
      code = -12;
      goto closeandexit;
    };
    //
    // run over all the events of the run
    //
    if (verbose) printf("\n Ready to start! \n\n Processed events: \n\n");
    //
    for ( re = runinfo->EV_FROM; re < (runinfo->EV_FROM+runinfo->NEVENTS); re++){
      //
      if ( procev%1000 == 0 && procev > 0 && verbose ) printf(" %iK \n",procev/1000);	
      //
      l0head->GetEntry(re);
      //
      // absolute time of this event
      //
      ph = eh->GetPscuHeader();
      atime = dbtime->DBabsTime(ph->GetOrbitalTime());  
      //
      // paranoid check
      //
      if ( (atime > runinfo->RUNTRAILER_TIME) || (atime < runinfo->RUNHEADER_TIME)  ) {
	if (verbose) printf(" OrbitalInfo - WARNING: event at time outside the run time window, skipping it\n");
	goto jumpev;
      };
      //
      procev++;
      //
      // start processing
      //
      orbitalinfo->Clear();
      //
      // CHANGE HERE!!!!
      //
      orbitalinfo->absTime = atime;
      // EM: add OBT and plt_num infos from the header
      ph = eh->GetPscuHeader();
      orbitalinfo->pkt_num = ph->GetCounter();
      orbitalinfo->OBT = ph->GetOrbitalTime();
      // end EM
      OrbitalInfotr->Fill();
      //    
      //
    jumpev:
      debug = false;
      //
    };
    //
    // Here you may want to clear some variables before processing another run  
    //
    delete dbtime;
  }; // process all the runs
  //
  if (verbose) printf("\n Finished processing data \n");
  //
 closeandexit:
  //
  // we have finished processing the run(s). If we processed a single run now we must copy all the events after our run from the old tree to the new one and delete the old tree.
  //
  if ( !reprocall && reproc && code >= 0 ){
    if ( totfileentries > noaftrun ){
      if (verbose){
	printf("\n Post-processing: copying events from the old tree after the processed run\n");   
	printf(" Copying %i events in the file which are after the end of the run %i \n",(int)(totfileentries-noaftrun),(int)run);
	printf(" Start copying at event number %i end copying at event number %i \n",(int)noaftrun,(int)totfileentries);
      }
      for (UInt_t j = noaftrun; j < totfileentries; j++ ){
	//
	// Get entry from old tree
	//
	OrbitalInfotrclone->GetEntry(j);	  
	//
	// copy orbitalinfoclone to OrbitalInfo
	//
	orbitalinfo->Clear();
	//
	memcpy(&orbitalinfo,&orbitalinfoclone,sizeof(orbitalinfoclone));
	//
	// Fill entry in the new tree
	//
	OrbitalInfotr->Fill();
      };
      if (verbose) printf(" Finished successful copying!\n");
    };
  };
  //
  // Close files, delete old tree(s), write and close level2 file 
  //
  if ( l0File ) l0File->Close();
  if ( tempfile ) tempfile->Close();            
  gSystem->Unlink(tempname.str().c_str());
  //
  if ( runinfo ) runinfo->Close();    
  if ( OrbitalInfotr ) OrbitalInfotr->SetName("OrbitalInfo");    
  if ( file ){
    file->cd();
    file->Write();
  };
  //
  gSystem->Unlink(OrbitalInfofolder.str().c_str());
  //
  // the end
  //
  if (verbose) printf("\n Exiting...\n");
  if(OrbitalInfotr)OrbitalInfotr->Delete();
  //
  if ( orbitalinfo ) delete orbitalinfo;
  if ( orbitalinfoclone ) delete orbitalinfoclone;
  if ( glroot ) delete glroot;
  if ( runinfo ) delete runinfo; 
  //
  if(code < 0)  throw code;
  return(code);
}

